# getDirectoryToWatchFailedLookupLocationInsubDirNonRecursive

Determines whether to watch given failed lookup location (file that didnt exist) when resolving module.
It also determines the directory to watch and whether to watch it recursively or not.

## Testing for UncDos root: //vda1cs4850/c$

## RootDirForResolution: //vda1cs4850/c$

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot/folder1

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir                                                                    | true      |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | true      |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | true      |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | true      |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | true      |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot/folder1/folder2

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir                                                            | true      |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | true      |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | true      |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | true      |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | true      |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | true      |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | true      |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/users

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/users/username

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot/folder1

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir                                                     | true      |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | true      |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | true      |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | true      |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/user

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/user/username

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir                                                                           | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir                                                              | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | true      |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot/folder1

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir                                                      | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | true      |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/usr

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/usr/username

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir                                                                            | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir                                                               | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | true      |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot/folder1

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir                                                       | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | true      |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | true      |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/home

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/home/username

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir                                                                           | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir                                                              | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot/folder1

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir                                                      | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir                                              | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/workspaces

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/workspaces/folderAtRoot

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir                                                                 | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | true      |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/workspaces/folderAtRoot/folder1

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir                                                         | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir                                                 | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | true      |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | true      |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir/subdir                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                             |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir/subdir                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                             |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir/subdir                                                                              | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir/subdir                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                             |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir/subdir                                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir/subdir                                                                    | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/dir/subdir                                                                       | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | true      |                                                                                                             |

